<?php
// backend/api.php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', '0');

$cfg = include __DIR__ . '/config.php';
$mysqli = new mysqli($cfg['host'], $cfg['user'], $cfg['pass'], $cfg['name']);
if ($mysqli->connect_errno) {
  http_response_code(500);
  echo json_encode(['error' => 'DB connection failed: ' . $mysqli->connect_error]);
  exit;
}
$mysqli->set_charset($cfg['charset']);

function j($d){ echo json_encode($d, JSON_UNESCAPED_UNICODE); exit; }
function getBody(){ $b = json_decode(file_get_contents('php://input'), true); return $b ?: []; }

$action = $_GET['action'] ?? null;
$method = $_SERVER['REQUEST_METHOD'];
$body = getBody();

// Auth: login
if ($action === 'auth_login' && $method === 'POST') {
  $email = $mysqli->real_escape_string($body['email'] ?? '');
  $password = $body['password'] ?? '';
  $res = $mysqli->query("SELECT id,name,role,email,password FROM users WHERE email = '$email' LIMIT 1");
  if (!$res || $res->num_rows === 0) j(['error'=>'Invalid credentials']);
  $u = $res->fetch_assoc();
  if ($u['password'] !== $password) j(['error'=>'Invalid credentials']);
  j(['token'=>$u['id'], 'user'=>['id'=>$u['id'],'name'=>$u['name'],'role'=>$u['role'],'email'=>$u['email']]]);
}

// Apps CRUD
if ($action === 'apps_create' && $method === 'POST') {
  $name = $mysqli->real_escape_string($body['name'] ?? '');
  $pkg = $mysqli->real_escape_string($body['packageId'] ?? '');
  $platform = $mysqli->real_escape_string($body['platform'] ?? 'ANDROID');
  $live = !empty($body['live']) ? 1 : 0;
  $pkgSql = $pkg !== '' ? "'".$pkg."'" : 'NULL';
  $mysqli->query("INSERT INTO apps (name,package_id,platform,live,created_at) VALUES ('$name',$pkgSql,'$platform',$live,NOW())");
  $id = $mysqli->insert_id;
  $res = $mysqli->query("SELECT * FROM apps WHERE id = $id"); j($res->fetch_assoc());
}
if ($action === 'apps_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT * FROM apps ORDER BY created_at DESC');
  $out = []; while ($r = $res->fetch_assoc()) $out[] = $r; j($out);
}
if ($action === 'apps_update' && $method === 'POST') {
  $id = intval($_GET['id'] ?? 0);
  if (!$id) j(['error'=>'missing id']);
  $sets = [];
  if (isset($body['name'])) $sets[] = "name='".$mysqli->real_escape_string($body['name'])."'";
  if (isset($body['packageId'])) $sets[] = "package_id='".$mysqli->real_escape_string($body['packageId'])."'";
  if (isset($body['platform'])) $sets[] = "platform='".$mysqli->real_escape_string($body['platform'])."'";
  if (isset($body['live'])) $sets[] = "live=".(!empty($body['live'])?1:0);
  if (empty($sets)) j(['error'=>'no fields']);
  $mysqli->query('UPDATE apps SET '.implode(',', $sets).' WHERE id = '.$id);
  $res = $mysqli->query('SELECT * FROM apps WHERE id = '.$id); j($res->fetch_assoc());
}

// References
if ($action === 'references_create' && $method === 'POST') {
  $name = $mysqli->real_escape_string($body['name'] ?? '');
  $mysqli->query("INSERT INTO references_tbl (name) VALUES ('$name')");
  j(['id'=>$mysqli->insert_id,'name'=>$body['name']]);
}
if ($action === 'references_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT * FROM references_tbl');
  $o=[]; while($r=$res->fetch_assoc()) $o[]=$r; j($o);
}

// Customers
if ($action === 'customers_create' && $method === 'POST') {
  $name = $mysqli->real_escape_string($body['name'] ?? '');
  $phone = $mysqli->real_escape_string($body['phone'] ?? '');
  $whatsapp = isset($body['whatsapp']) ? $mysqli->real_escape_string($body['whatsapp']) : null;
  $referenceId = isset($body['referenceId']) ? intval($body['referenceId']) : 'NULL';
  $whSql = $whatsapp !== null ? "'".$whatsapp."'" : 'NULL';
  $mysqli->query("INSERT INTO customers (name,phone,whatsapp,reference_id,created_at,balance,paid) VALUES ('$name','$phone',$whSql, $referenceId, NOW(), 0, 0)"); 
  $id = $mysqli->insert_id; $res=$mysqli->query('SELECT * FROM customers WHERE id = '.$id); j($res->fetch_assoc());
}
if ($action === 'customers_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT c.*, r.name as reference_name FROM customers c LEFT JOIN references_tbl r ON r.id = c.reference_id ORDER BY c.created_at DESC');
  $o=[]; while($r=$res->fetch_assoc()) $o[] = $r; j($o);
}

// Payments
if ($action === 'payments_create' && $method === 'POST') {
  $orderId = isset($body['orderId']) ? intval($body['orderId']) : 'NULL';
  $customerId = isset($body['customerId']) ? intval($body['customerId']) : 'NULL';
  $amount = floatval($body['amount'] ?? 0);
  $status = $mysqli->real_escape_string($body['status'] ?? 'FULL');
  $methodp = $mysqli->real_escape_string($body['method'] ?? '');
  $txn = $mysqli->real_escape_string($body['txnRef'] ?? '');
  $methodSql = $methodp !== '' ? "'".$methodp."'" : 'NULL';
  $txnSql = $txn !== '' ? "'".$txn."'" : 'NULL';
  $mysqli->query("INSERT INTO payments (order_id,customer_id,amount,status,method,txn_ref,created_at) VALUES ($orderId,$customerId,$amount,'$status',$methodSql,$txnSql, NOW())");
  $pid = $mysqli->insert_id;
  if ($customerId !== 'NULL') {
    $mysqli->query('UPDATE customers SET paid = paid + '.$amount.', balance = GREATEST(balance - '.$amount.',0) WHERE id = '.$customerId);
  }
  $res = $mysqli->query('SELECT * FROM payments WHERE id = '.$pid); j($res->fetch_assoc());
}
if ($action === 'payments_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT * FROM payments ORDER BY created_at DESC'); $o=[]; while($r=$res->fetch_assoc()) $o[]=$r; j($o);
}

// Orders
if ($action === 'orders_create' && $method === 'POST') {
  $customerId = isset($body['customerId']) ? intval($body['customerId']) : 'NULL';
  $referenceSource = isset($body['referenceSource']) ? $mysqli->real_escape_string($body['referenceSource']) : null;
  $startDate = isset($body['startDate']) ? $mysqli->real_escape_string($body['startDate']) : null;
  $endDate = isset($body['endDate']) ? $mysqli->real_escape_string($body['endDate']) : null;
  $custSql = $customerId === 'NULL' ? 'NULL' : $customerId;
  $refSql = $referenceSource !== null ? "'".$referenceSource."'" : 'NULL';
  $startSql = $startDate !== null ? "'".$startDate."'" : 'NULL';
  $endSql = $endDate !== null ? "'".$endDate."'" : 'NULL';
  $mysqli->query("INSERT INTO orders (customer_id,reference_source,start_date,end_date,status,tester_passed,tester_comment,created_at) VALUES ($custSql,$refSql,$startSql,$endSql,'PENDING',NULL,NULL,NOW())");
  $orderId = $mysqli->insert_id;
  if (!empty($body['items']) && is_array($body['items'])) {
    $ins = $mysqli->prepare('INSERT INTO order_items (order_id,app_id,target_installs,price) VALUES (?,?,?,?)');
    foreach ($body['items'] as $it) {
      $ai = intval($it['appId'] ?? 0);
      $ti = intval($it['targetInstalls'] ?? 0);
      $pr = floatval($it['price'] ?? 0);
      $ins->bind_param('iiid', $orderId, $ai, $ti, $pr);
      $ins->execute();
    }
  }
  $sumRes = $mysqli->query('SELECT IFNULL(SUM(price),0) as s FROM order_items WHERE order_id = '.$orderId);
  $sum = $sumRes->fetch_assoc()['s'] ?? 0;
  if ($customerId !== 'NULL') $mysqli->query('UPDATE customers SET balance = balance + '.$sum.' WHERE id = '.$customerId);
  j(['orderId'=>$orderId,'total'=>floatval($sum)]);
}
if ($action === 'orders_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT o.*, c.name as customer_name, c.phone as customer_phone FROM orders o LEFT JOIN customers c ON c.id = o.customer_id ORDER BY o.created_at DESC');
  $orders = [];
  while ($o = $res->fetch_assoc()) {
    $itemsRes = $mysqli->query('SELECT oi.*, a.name as app_name, a.package_id FROM order_items oi LEFT JOIN apps a ON a.id = oi.app_id WHERE oi.order_id = '.intval($o['id']));
    $items = [];
    while ($it = $itemsRes->fetch_assoc()) {
      $countRes = $mysqli->query('SELECT COUNT(*) as c FROM installations WHERE app_id = '.intval($it['app_id']));
      $count = $countRes->fetch_assoc()['c'] ?? 0;
      $it['installs'] = intval($count);
      $items[] = $it;
    }
    $o['items'] = $items;
    $orders[] = $o;
  }
  j($orders);
}
if ($action === 'orders_update' && $method === 'POST') {
  $id = intval($_GET['id'] ?? 0); if (!$id) j(['error'=>'missing id']);
  $sets = [];
  if (isset($body['status'])) $sets[] = "status='".$mysqli->real_escape_string($body['status'])."'";
  if (isset($body['tester_passed'])) $sets[] = "tester_passed=".($body['tester_passed']?1:0);
  if (isset($body['tester_comment'])) $sets[] = "tester_comment='".$mysqli->real_escape_string($body['tester_comment'])."'";
  if (empty($sets)) j(['error'=>'no fields']);
  $mysqli->query('UPDATE orders SET '.implode(',', $sets).' WHERE id = '.$id);
  $r = $mysqli->query('SELECT * FROM orders WHERE id = '.$id); j($r->fetch_assoc());
}

// Installations
if ($action === 'installations_report' && $method === 'POST') {
  $deviceId = $mysqli->real_escape_string($body['deviceId'] ?? '');
  $appId = intval($body['appId'] ?? 0);
  $status = $mysqli->real_escape_string($body['status'] ?? 'INSTALLED');
  $res = $mysqli->query("SELECT * FROM installations WHERE device_id = '$deviceId' AND app_id = $appId LIMIT 1");
  $now = date('c');
  if ($res && $res->num_rows) {
    $row = $res->fetch_assoc();
    $mysqli->query("UPDATE installations SET status = '$status', last_seen = '$now' WHERE id = " . intval($row['id']));
    $r = $mysqli->query('SELECT * FROM installations WHERE id = '.intval($row['id'])); j($r->fetch_assoc());
  } else {
    $mysqli->query("INSERT INTO installations (device_id,app_id,status,first_seen,last_seen) VALUES ('{$deviceId}', $appId, '$status', '$now', '$now')");
    $id = $mysqli->insert_id; $r = $mysqli->query('SELECT * FROM installations WHERE id = '.$id); j($r->fetch_assoc());
  }
}
if ($action === 'installations_summary' && $method === 'GET') {
  $res = $mysqli->query('SELECT * FROM apps'); $out=[];
  while($a=$res->fetch_assoc()){
    $cRes = $mysqli->query('SELECT COUNT(*) as c FROM installations WHERE app_id = '.intval($a['id']));
    $c = $cRes->fetch_assoc()['c'] ?? 0;
    $out[] = ['appId'=>$a['id'],'appName'=>$a['name'],'installs'=>intval($c),'live'=>boolval($a['live'])];
  }
  j($out);
}

// Notes
if ($action === 'notes_create' && $method === 'POST') {
  $scope = $mysqli->real_escape_string($body['scope'] ?? 'GLOBAL');
  $bodyText = $mysqli->real_escape_string($body['body'] ?? '');
  $orderId = isset($body['orderId']) ? intval($body['orderId']) : 'NULL';
  $mysqli->query("INSERT INTO notes (scope,body,order_id,created_at) VALUES ('$scope','$bodyText',".($orderId==='NULL'?'NULL':$orderId).",NOW())");
  j(['ok'=>true]);
}
if ($action === 'notes_list' && $method === 'GET') {
  $res = $mysqli->query('SELECT * FROM notes ORDER BY created_at DESC'); $o=[]; while($r=$res->fetch_assoc()) $o[]=$r; j($o);
}

// Dashboard
if ($action === 'dashboard' && $method === 'GET') {
  $totalCustomers = intval($mysqli->query('SELECT COUNT(*) as c FROM customers')->fetch_assoc()['c']);
  $totalApps = intval($mysqli->query('SELECT COUNT(*) as c FROM apps')->fetch_assoc()['c']);
  $totalOrders = intval($mysqli->query('SELECT COUNT(*) as c FROM orders')->fetch_assoc()['c']);
  $totalPaid = floatval($mysqli->query('SELECT IFNULL(SUM(amount),0) as s FROM payments')->fetch_assoc()['s']);
  $totalBalance = floatval($mysqli->query('SELECT IFNULL(SUM(balance),0) as s FROM customers')->fetch_assoc()['s']);
  j(['totalCustomers'=>$totalCustomers,'totalApps'=>$totalApps,'totalOrders'=>$totalOrders,'totalPaid'=>$totalPaid,'totalBalance'=>$totalBalance]);
}

j(['error'=>'unknown action']);
?>
