<?php
// admin/index.php - static admin UI that calls backend/api.php?action=...
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>12 Testers — Admin (MySQL)</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">
  <div class="max-w-6xl mx-auto p-6">
    <header class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold">12 Testers — Admin Panel</h1>
    </header>

    <main class="grid grid-cols-3 gap-6">
      <section class="col-span-2 space-y-6">
        <div class="bg-white p-4 rounded shadow">
          <h2 class="font-semibold text-lg mb-2">Dashboard</h2>
          <div class="grid grid-cols-4 gap-4">
            <div class="p-3 border rounded"><div class="text-sm text-gray-500">Customers</div><div id="dashCustomers" class="text-xl font-bold">0</div></div>
            <div class="p-3 border rounded"><div class="text-sm text-gray-500">Apps</div><div id="dashApps" class="text-xl font-bold">0</div></div>
            <div class="p-3 border rounded"><div class="text-sm text-gray-500">Orders</div><div id="dashOrders" class="text-xl font-bold">0</div></div>
            <div class="p-3 border rounded"><div class="text-sm text-gray-500">Total Balance</div><div id="dashBalance" class="text-xl font-bold">0</div></div>
          </div>
        </div>

        <div class="bg-white p-4 rounded shadow">
          <h2 class="font-semibold text-lg mb-2">Create Customer</h2>
          <div class="grid grid-cols-3 gap-3">
            <input id="custName" placeholder="Name" class="p-2 border rounded"/>
            <input id="custPhone" placeholder="Phone" class="p-2 border rounded"/>
            <select id="custRef" class="p-2 border rounded"></select>
          </div>
          <div class="mt-3">
            <button onclick="createCustomer()" class="px-4 py-2 bg-blue-600 text-white rounded">Add Customer</button>
          </div>
        </div>

        <div class="bg-white p-4 rounded shadow">
          <h2 class="font-semibold text-lg mb-2">Create Order</h2>
          <div class="grid grid-cols-3 gap-3">
            <select id="orderCustomer" class="p-2 border rounded"></select>
            <input id="orderStart" type="date" class="p-2 border rounded"/>
            <input id="orderEnd" type="date" class="p-2 border rounded"/>
          </div>
          <div class="mt-3">
            <label class="block text-sm text-gray-600 mb-1">Select Apps (hold ctrl to select multiple)</label>
            <select id="orderApps" multiple class="w-full p-2 border rounded h-28"></select>
          </div>
          <div class="mt-3">
            <button onclick="createOrder()" class="px-4 py-2 bg-green-600 text-white rounded">Create Order</button>
          </div>
        </div>

        <div class="bg-white p-4 rounded shadow">
          <h2 class="font-semibold text-lg mb-2">Recent Orders</h2>
          <div id="ordersList" class="space-y-2"></div>
        </div>

      </section>

      <aside class="space-y-6">
        <div class="bg-white p-4 rounded shadow">
          <h3 class="font-semibold mb-2">Add App</h3>
          <input id="appName" placeholder="App name" class="w-full p-2 border rounded mb-2"/>
          <input id="appPkg" placeholder="Package ID" class="w-full p-2 border rounded mb-2"/>
          <select id="appPlatform" class="w-full p-2 border rounded mb-2"><option>ANDROID</option><option>IOS</option><option>WEB</option></select>
          <label class="flex items-center gap-2"><input id="appLive" type="checkbox"/> Live</label>
          <div class="mt-3"><button onclick="addApp()" class="w-full px-4 py-2 bg-indigo-600 text-white rounded">Add App</button></div>
        </div>

        <div class="bg-white p-4 rounded shadow">
          <h3 class="font-semibold mb-2">Install Summary</h3>
          <div id="summary" class="space-y-1 text-sm text-gray-700"></div>
          <div class="mt-2"><button onclick="loadSummary()" class="px-3 py-1 bg-gray-200 rounded">Refresh</button></div>
        </div>

        <div class="bg-white p-4 rounded shadow">
          <h3 class="font-semibold mb-2">Payments</h3>
          <select id="payCustomer" class="w-full p-2 border rounded mb-2"></select>
          <input id="payAmount" placeholder="Amount" class="w-full p-2 border rounded mb-2"/>
          <select id="payStatus" class="w-full p-2 border rounded mb-2"><option>FULL</option><option>HALF</option></select>
          <input id="payMethod" placeholder="Method (UPI/Cash)" class="w-full p-2 border rounded mb-2"/>
          <input id="payTxn" placeholder="Txn Ref" class="w-full p-2 border rounded mb-2"/>
          <button onclick="addPayment()" class="w-full px-3 py-2 bg-yellow-600 text-white rounded">Add Payment</button>
        </div>

      </aside>
    </main>
  </div>

<script>
const base = (location.hostname === 'localhost' || location.hostname === '127.0.0.1') ? '/backend/api.php' : '/backend/api.php';

async function call(action, opts = {}){
  const url = base + '?action=' + encodeURIComponent(action) + (opts.query?('&'+opts.query):'');
  const cfg = { method: opts.method || (opts.body ? 'POST' : 'GET'), headers: {'Content-Type':'application/json'} };
  if (opts.body) cfg.body = JSON.stringify(opts.body);
  const r = await fetch(url, cfg);
  return r.json();
}

async function refreshDashboard(){ const d = await call('dashboard'); document.getElementById('dashCustomers').innerText = d.totalCustomers; document.getElementById('dashApps').innerText = d.totalApps; document.getElementById('dashOrders').innerText = d.totalOrders; document.getElementById('dashBalance').innerText = d.totalBalance; }

async function loadRefs(){ const refs = await call('references_list'); const sel = document.getElementById('custRef'); sel.innerHTML = '<option value="">-- None --</option>' + refs.map(r=>'<option value="'+r.id+'">'+r.name+'</option>').join(''); }
async function loadCustomers(){ const cs = await call('customers_list'); const sel = document.getElementById('orderCustomer'); const paySel = document.getElementById('payCustomer'); sel.innerHTML = cs.map(c=>'<option value="'+c.id+'">'+c.name+' ('+(c.phone||'')+') - Balance: '+(c.balance||0)+'</option>').join(''); paySel.innerHTML = '<option value="">Select customer</option>' + cs.map(c=>'<option value="'+c.id+'">'+c.name+' - Balance: '+(c.balance||0)+'</option>').join(''); }
async function loadApps(){ const apps = await call('apps_list'); const sel = document.getElementById('orderApps'); sel.innerHTML = apps.map(a=>'<option value="'+a.id+'">'+a.name+' - '+(a.live? 'Live':'Not Live')+'</option>').join(''); const appSummary = document.getElementById('summary'); appSummary.innerHTML = apps.map(a=>'<div>'+a.name+' ('+a.package_id+') - '+(a.live?'Live':'Not Live')+'</div>').join(''); }

async function addApp(){ const name = document.getElementById('appName').value; const packageId = document.getElementById('appPkg').value; const platform = document.getElementById('appPlatform').value; const live = document.getElementById('appLive').checked; await call('apps_create',{ body:{ name, packageId, platform, live } }); loadApps(); refreshDashboard(); alert('App added'); }

async function createCustomer(){ const name = document.getElementById('custName').value; const phone = document.getElementById('custPhone').value; const ref = document.getElementById('custRef').value || null; await call('customers_create',{ body:{ name, phone, referenceId: ref } }); loadCustomers(); refreshDashboard(); alert('Customer created'); }

async function createOrder(){ const customerId = document.getElementById('orderCustomer').value; const startDate = document.getElementById('orderStart').value; const endDate = document.getElementById('orderEnd').value; const selected = Array.from(document.getElementById('orderApps').selectedOptions).map(o=>o.value); const items = selected.map(id=>({ appId: id, targetInstalls: 1, price: 100 })); await call('orders_create',{ body:{ customerId, startDate, endDate, items } }); loadOrders(); refreshDashboard(); alert('Order created'); }

async function loadOrders(){ const orders = await call('orders_list'); const el = document.getElementById('ordersList'); el.innerHTML = orders.map(o=>`<div class="p-2 border rounded"><div class="text-sm text-gray-500">Order: ${o.id}</div><div><strong>Customer:</strong> ${o.customer_name||'-'} (${o.customer_phone||''})</div><div><strong>Items:</strong> ${o.items.map(it=>it.app_name||'-').join(', ')}</div><div><strong>Installs:</strong> ${o.items.map(it=>it.installs).join(', ')}</div><div class="mt-2"><button onclick="openOrder('${o.id}')" class="px-2 py-1 bg-gray-100 rounded">Open</button></div></div>`).join(''); }

async function openOrder(id){ const orders = await call('orders_list'); const o = orders.find(x=>x.id==id); if(!o) return alert('Not found'); const update = prompt('Set status (PENDING/IN_PROGRESS/DONE) or leave blank'); if(update){ await call('orders_update',{ query:'id='+encodeURIComponent(id), body:{ status: update } }); loadOrders(); } }

async function loadSummary(){ const s = await call('installations_summary'); document.getElementById('summary').innerHTML = s.map(x=>'<div>'+x.appName+' - installs: '+x.installs+'</div>').join(''); }

async function addPayment(){ const customerId = document.getElementById('payCustomer').value; const amount = parseFloat(document.getElementById('payAmount').value||0); const status = document.getElementById('payStatus').value; const method = document.getElementById('payMethod').value; const txn = document.getElementById('payTxn').value; if(!customerId) return alert('Select customer'); await call('payments_create',{ body:{ customerId, amount, status, method, txnRef: txn } }); loadCustomers(); refreshDashboard(); alert('Payment recorded'); }

(async ()=>{ await call('references_create',{ body:{ name:'Google Ads' } }); await loadRefs(); await loadCustomers(); await loadApps(); await loadOrders(); await refreshDashboard(); })();
</script>
</body>
</html>
